import QtQuick 2.12
import QtQuick.Controls 2.5
import QtQuick.Layouts 1.3
import Qt5Compat.GraphicalEffects
import QtQml 2.12

Item {
    id: app
    focus: true

    property variant numbers: []
    property int cols: 4
    property int rows: 4
    property int finalValue: 2048
    property int score: 0

    function numberAt(col, row) {
        for (var i = 0; i < numbers.length; i++) {
            if (numbers[i].col === col && numbers[i].row === row)
                return numbers[i]
        }
    }
    function popNumberAt(col, row) {
        var tmp = numbers
        for (var i = 0; i < tmp.length; i++) {
            if (tmp[i].col === col && tmp[i].row === row) {
                tmp[i].destroy()
                tmp.splice(i, 1)
            }
        }
        numbers=tmp
    }
    function purge() {
        score = 0
        var tmp = numbers
        for (var i = 0; i < tmp.length; i++) {
            tmp[i].destroy()
        }
        tmp = Array()
        numbers = tmp
        gen2();
        gen2();
    }
    function checkNotStuck() {
        for (var i = 0; i < app.cols; i++) {
            for (var j = 0; j < app.rows; j++) {
                if (!numberAt(i, j))
                    return true
                if (numberAt(i+1,j) && numberAt(i,j).number === numberAt(i+1,j).number)
                    return true
                if (numberAt(i-1,j) && numberAt(i,j).number === numberAt(i-1,j).number)
                    return true
                if (numberAt(i,j+1) && numberAt(i,j).number === numberAt(i,j+1).number)
                    return true
                if (numberAt(i,j-1) && numberAt(i,j).number === numberAt(i,j-1).number)
                    return true
            }
        }
        return false
    }


    Component {
        id: number

        Rectangle {
            id: colorRect
            color: number <=    1 ? "transparent" :
                   number <=    2 ? "#A7AEEC" :
                   number <=    4 ? "#969FF3" :
                   number <=    8 ? "#7982F2" :
                   number <=   16 ? "#6367F5" :
                   number <=   32 ? "#564DDE" :
                   number <=   64 ? "#583BF6" :
                   number <=  128 ? "#729EED" :
                   number <=  256 ? "#6163ED" :
                   number <=  512 ? "#5062ED" :
                   number <= 1024 ? "#3F3FED" :
                   number <= 2048 ? "#382EED" :
                                    "#32323C"

            property int col
            property int row

            property int number: Math.random() > 0.9 ? 4 : 2

            x: cells.getAt(col, row).x
            y: cells.getAt(col, row).y
            width: cells.getAt(col, row).width
            height: cells.getAt(col, row).height
            radius: cells.getAt(col, row).radius

            function move(h, v) {
                if (h === col && v === row)
                    return false
                if (app.numberAt(h, v)) {
                    number += app.numberAt(h, v).number
                    app.score += number
                    if (number === finalValue)
                        app.victory()
                    app.popNumberAt(h, v)
                }
                col = h
                row = v
                return true
            }

            Text {
                id: text

                width: parent.width * 0.9
                height: parent.height * 0.9
                anchors.centerIn: parent

                font.family: "monospace"
                font.bold: true
                font.pixelSize: parent.height
                fontSizeMode: Text.Fit
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter

                text: parent.number > 1 ? parent.number : ""
            }

            Behavior on x {
                NumberAnimation {
                    duration: 50
                    easing {
                        type: Easing.InOutQuad
                    }
                }
            }
            Behavior on y {
                NumberAnimation {
                    duration: 50
                    easing {
                        type: Easing.InOutQuad
                    }
                }
            }

            transform: Scale {
                id: zoomIn
                origin.x: colorRect.width / 2
                origin.y: colorRect.height / 2
                xScale: 0
                yScale: 0
                Behavior on xScale {
                    NumberAnimation {
                        duration: 200
                        easing {
                            type: Easing.InOutQuad
                        }
                    }
                }
                Behavior on yScale {
                    NumberAnimation {
                        duration: 200
                        easing {
                            type: Easing.InOutQuad
                        }
                    }
                }
            }

            Component.onCompleted: {
                zoomIn.xScale = 1
                zoomIn.yScale = 1
            }
        }
    }



    ColumnLayout
    {
        spacing: 0
        anchors.fill: parent
        anchors.margins: 16

        RowLayout{
            spacing: 0
            Layout.preferredHeight: 40

            Text {
                id: scorePanel
                Layout.alignment: Qt.AlignLeft
                Layout.fillWidth: true
//                Layout.fillHeight: true

                color: "#ffffff"
                font.family: "Quicksand"
                font.pixelSize: 16
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter

                text: "Score: " + app.score
            }



            Rectangle{
                Layout.preferredWidth: 120
                Layout.preferredHeight: 40

                color: area.containsMouse ? "#474A51" : "#262729"
                radius:10

                Text {
                    anchors.centerIn: parent

                    color: "#ffffff"
                    font.family: "Quicksand"
                    font.pixelSize: 13
                    horizontalAlignment: Text.AlignLeft
                    verticalAlignment: Text.AlignVCenter

                    text: "New game"
                }

                MouseArea{
                    id: area
                    anchors.fill: parent
                    hoverEnabled: true
                    onClicked: {
                        app.purge()
                        message.hide()
                    }
                }
            }
        }

        Rectangle{
            Layout.topMargin: 20
            Layout.fillHeight: true
            Layout.fillWidth: true
            color: "#212224"
            radius: 10

            /* mask source */
            Rectangle {
                id: contenMask
                anchors.fill: parent
                color: "#212224"
                radius: 10

                visible: false
            }
            /* mask */
            OpacityMask {
                anchors.fill: board
                source: board
                maskSource: contenMask
            }

            Item {
                id: board
                anchors.fill: parent
                opacity: 0

                Grid {
                    id: cellGrid

                    anchors.fill: parent
                    opacity: 1

                    rows: app.rows
                    columns: app.cols
                    spacing: (parent.width + parent.height) / app.rows / app.cols / 4

                    property real cellWidth: (width - (columns - 1) * spacing) / columns
                    property real cellHeight: (height - (rows - 1) * spacing) / rows

                    Repeater {
                        id: cells
                        model: app.cols * app.rows
                        function getAt(h, v) {
                            return itemAt(h + v * app.cols)
                        }
                        function getRandom() {
                            return itemAt(Math.floor((Math.random() * 16)%16))
                        }
                        function getRandomFree() {
                            var free = new Array()
                            for (var i = 0; i < app.cols; i++) {
                                for (var j = 0; j < app.rows; j++) {
                                    if (!numberAt(i, j)) {
                                        free.push(getAt(i, j))
                                    }
                                }
                            }
                            return free[Math.floor(Math.random()*free.length)]
                        }
                        Rectangle {
                            width: parent.cellWidth
                            height: parent.cellHeight
                            color: "#32323C"
                            radius: 2

                            property int col : index % app.cols
                            property int row : index / app.cols
                        }
                    }
                }

                Item {
                    id: numbersLayer
                    anchors.fill: parent
                }
            }

            MouseArea {
                anchors.fill: parent
                property int minimumLength: app.width < app.height ? app.width / 5 : app.height / 5
                property int startX
                property int startY
                onPressed: function(mouse) {
                    startX = mouse.x
                    startY = mouse.y
                }
                onReleased: function(mouse) {
                    var length = Math.sqrt(Math.pow(mouse.x - startX, 2) + Math.pow(mouse.y - startY, 2))
                    if (length < minimumLength)
                        return
                    var diffX = mouse.x - startX
                    var diffY = mouse.y - startY
                    // not sure what the exact angle is but it feels good
                    if (Math.abs(Math.abs(diffX) - Math.abs(diffY)) < minimumLength / 2)
                        return
                    if (Math.abs(diffX) > Math.abs(diffY))
                        if (diffX > 0)
                            app.move(1, 0)
                        else
                            app.move(-1, 0)
                    else
                        if (diffY > 0)
                            app.move(0, 1)
                        else
                            app.move(0, -1)
                }
            }

            Item {
                id: messagePopup
                anchors.fill: parent
                opacity: 0

//                Rectangle{
//                    anchors.fill: parent
//                    color: "#474A51"
//                    opacity: 0.5
//                }

                Rectangle {
                    id: message
                    width: parent.width * 0.9
                    height: parent.height * 0.4
                    anchors.centerIn: parent
                    opacity: parent.opacity
                    color: "#17171A"
                    radius: 12
                    z: 1

                    Text {
                        anchors.fill: parent
                        id: messageText

                        font.family: "Quicksand"
                        font.pixelSize: 18
                        color: "#ffffff"
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
//                        elide: Text.ElideMiddle
                        wrapMode: Text.WordWrap
                    }

                    function hide() {
                        visible = false
                        messagePopup.opacity = 0.0
                        messageText.text = ""
                    }
                    function show(text) {
                        visible = true
                        messagePopup.opacity = 1
                        messageText.text = text
                    }

                    Behavior on opacity {
                        NumberAnimation {
                            duration: 200
                        }
                    }
                }

                MouseArea{
                    enabled: parent.opacity
                    anchors.fill: parent
                    hoverEnabled: true
                    onClicked: {
                        app.purge()
                        message.hide()
                    }
                }
            }
        }
    }

    function gen2() {
        var tmp = numbers
        var cell = cells.getRandomFree()
        var newNumber = number.createObject(numbersLayer,{"col":cell.col,"row":cell.row})
        tmp.push(newNumber)
        numbers = tmp
    }
    // oh  my, this HAS TO be rewritten
    function move(col, row) {
        var somethingMoved = false
        var tmp = numbers
        if (col > 0) {
            for (var j = 0; j < app.rows; j++) {
                var filled = 0
                var canMerge = false
                for (var i = app.cols - 1; i >= 0; i--) {
                    if (numberAt(i,j)) {
                        if (canMerge) {
                            if (numberAt(i,j).number === numberAt(app.cols-filled,j).number) {
                                canMerge = false
                                filled--
                            }
                        }
                        else {
                            canMerge = true
                        }
                        if (numberAt(i,j).move(app.cols-1-filled,j))
                            somethingMoved = true
                        filled++
                    }
                }
            }
        }
        if (col < 0) {
            for (var j = 0; j < app.rows; j++) {
                var filled = 0
                var canMerge = false
                for (var i = 0; i < app.cols; i++) {
                    if (numberAt(i,j)) {
                        if (canMerge) {
                            if (numberAt(i,j).number === numberAt(filled-1,j).number) {
                                canMerge = false
                                filled--
                            }
                        }
                        else {
                            canMerge = true
                        }
                        if (numberAt(i,j).move(filled,j))
                            somethingMoved = true
                        filled++
                    }
                }
            }
        }
        if (row > 0) {
            for (var i = 0; i < app.cols; i++) {
                var filled = 0
                var canMerge = false
                for (var j = app.rows - 1; j >= 0; j--) {
                    if (numberAt(i,j)) {
                        if (canMerge) {
                            if (numberAt(i,j).number === numberAt(i,app.rows-filled).number) {
                                canMerge = false
                                filled--
                            }
                        }
                        else {
                            canMerge = true
                        }
                        if (numberAt(i,j).move(i,app.rows-1-filled))
                            somethingMoved = true
                        filled++
                    }
                }
            }
        }
        if (row < 0) {
            for (var i = 0; i < app.cols; i++) {
                var filled = 0
                var canMerge = false
                for (var j = 0; j < app.rows; j++) {
                    if (numberAt(i,j)) {
                        if (canMerge) {
                            if (numberAt(i,j).number === numberAt(i,filled-1).number) {
                                canMerge = false
                                filled--
                            }
                        }
                        else {
                            canMerge = true
                        }
                        if (numberAt(i,j).move(i,filled))
                            somethingMoved = true
                        filled++
                    }
                }
            }
        }
        if (somethingMoved)
            gen2()
        if (!checkNotStuck())
            app.defeat()
    }

    function victory() {
        message.show("You win !!! \nClick to restart.")
    }
    function defeat() {
        message.show("Your score is "+ score.toString() +"\n\n Click to restart")
    }

    Component.onCompleted: {
        app.purge()
    }
    Keys.onPressed: {
        if (!message.visible) {
            if (event.key === Qt.Key_Left)
                app.move(-1, 0)
            if (event.key === Qt.Key_Right)
                app.move(1, 0)
            if (event.key === Qt.Key_Up)
                app.move(0, -1)
            if (event.key === Qt.Key_Down)
                app.move(0, 1)
        }
        if (event.key === Qt.Key_Space) {
            app.purge()
            message.hide()
        }
    }
}
